/* ---------------------------------------------------------------------------
    2016 HID Global Corporation/ASSA ABLOY AB.  All rights reserved.

   Redistribution and use in source and binary forms, with or without modification,
   are permitted provided that the following conditions are met:
      - Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
      - Redistributions in binary form must reproduce the above copyright notice,
        this list of conditions and the following disclaimer in the documentation
        and/or other materials provided with the distribution.
        THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
        AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
        THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
        ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
        FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
        (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
        LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
        ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
        (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
        THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 --------------------------------------------------------------------------- */

#include "stdafx.h"

#include "Scenarios.h"
#include "Scenarios.UI.h"
#include "Helper.h"

#define MAINMENU		_T("==================\n\nSelect a scenario:\n\t1. Data signature\n\t2. Login\n\t3. Secret key usage\n\t4. OTP generation\n\n\tQ. Quit")

//---------------------------
//	 Function: Main
//
//	Main function
//		return	int	Exit code
//		param	void
//---------------------------
int main (void)
{
	/* Local variables */
	int nMenuChoice = -1;
	TCHAR szUserEntry[BUFSIZ];

	/* Let the user select the scenario */
	do 
	{
		/* display menu */
		DisplayMenuHeader();
		fwprintf (stdout, _T("\n%s"), MAINMENU);

		/* get user selection */
		GetMenuChoice(1, 4, &nMenuChoice);

		/* on selection, do... */
		switch (nMenuChoice)
		{
			case 1:
				DisplayMenuHeader();
				DataSignatureScenario();
				GetString (_T("\nType enter to continue"), szUserEntry, (int)sizeof (szUserEntry));
				break;
			case 2:
				DisplayMenuHeader();
				LoginScenario();
				GetString (_T("\nType enter to continue"), szUserEntry, (int)sizeof (szUserEntry));
				break;
			case 3:
				DisplayMenuHeader();
				SecretKeyUsageScenario();
				GetString (_T("\nType enter to continue"), szUserEntry, (int)sizeof (szUserEntry));
				break;
			case 4:
				DisplayMenuHeader();
				OTPGenerationScenario();
				GetString (_T("\nType enter to continue"), szUserEntry, (int)sizeof (szUserEntry));
				break;
			case 0:
	
			default:
				break;
		}

	} while (nMenuChoice != 0);

	return 0;
}